/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBColumn;
import adql.db.DBTable;
import adql.db.DefaultDBTable;
import adql.db.FunctionDef;
import adql.db.STCS;
import adql.db.SearchColumnList;
import adql.db.SearchTableList;
import adql.db.exception.UnresolvedColumnException;
import adql.db.exception.UnresolvedFunctionException;
import adql.db.exception.UnresolvedIdentifiersException;
import adql.db.exception.UnresolvedTableException;
import adql.parser.ParseException;
import adql.parser.QueryChecker;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLQuery;
import adql.query.ClauseSelect;
import adql.query.ColumnReference;
import adql.query.IdentifierField;
import adql.query.SelectAllColumns;
import adql.query.SelectItem;
import adql.query.from.ADQLTable;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.StringConstant;
import adql.query.operand.UnknownType;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.DefaultUDF;
import adql.query.operand.function.UserDefinedFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import adql.search.SearchColumnHandler;
import adql.search.SimpleReplaceHandler;
import adql.search.SimpleSearchHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class DBChecker
implements QueryChecker {
    protected SearchTableList lstTables;
    protected String[] allowedGeo = null;
    protected String[] allowedCoordSys = null;
    protected String coordSysRegExp = null;
    protected FunctionDef[] allowedUdfs = null;

    public DBChecker() {
        this(null, null);
    }

    public DBChecker(Collection<? extends DBTable> collection) {
        this(collection, null);
    }

    public DBChecker(Collection<? extends DBTable> collection, Collection<? extends FunctionDef> collection2) {
        this.setTables(collection);
        if (collection2 != null) {
            FunctionDef[] functionDefArray = new FunctionDef[collection2.size()];
            int n = 0;
            for (FunctionDef functionDef : collection2) {
                if (functionDef == null || functionDef.name.trim().length() <= 0) continue;
                functionDefArray[n++] = functionDef;
            }
            this.allowedUdfs = (FunctionDef[])Arrays.copyOf(functionDefArray, n, FunctionDef[].class);
            functionDefArray = null;
            Arrays.sort(this.allowedUdfs);
        }
    }

    public DBChecker(Collection<? extends DBTable> collection, Collection<String> collection2, Collection<String> collection3) throws ParseException {
        this(collection, null, collection2, collection3);
    }

    public DBChecker(Collection<? extends DBTable> collection, Collection<? extends FunctionDef> collection2, Collection<String> collection3, Collection<String> collection4) throws ParseException {
        this(collection, collection2);
        this.allowedGeo = DBChecker.specialSort(collection3);
        this.allowedCoordSys = DBChecker.specialSort(collection4);
        this.coordSysRegExp = STCS.buildCoordSysRegExp(this.allowedCoordSys);
    }

    protected static final String[] specialSort(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (String string : collection) {
            if (string == null || string.trim().length() <= 0) continue;
            stringArray[n++] = string;
        }
        Object[] objectArray = Arrays.copyOf(stringArray, n);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public final void setTables(Collection<? extends DBTable> collection) {
        this.lstTables = collection == null ? new SearchTableList() : (collection instanceof SearchTableList ? (SearchTableList)collection : new SearchTableList(collection));
    }

    @Override
    public final void check(ADQLQuery aDQLQuery) throws ParseException {
        this.check(aDQLQuery, null);
    }

    protected void check(ADQLQuery aDQLQuery, Stack<SearchColumnList> stack) throws UnresolvedIdentifiersException {
        UnresolvedIdentifiersException unresolvedIdentifiersException = new UnresolvedIdentifiersException();
        SearchColumnList searchColumnList = this.checkDBItems(aDQLQuery, stack, unresolvedIdentifiersException);
        if (this.allowedUdfs != null) {
            this.checkUDFs(aDQLQuery, unresolvedIdentifiersException);
        }
        this.checkGeometries(aDQLQuery, unresolvedIdentifiersException);
        this.checkTypes(aDQLQuery, unresolvedIdentifiersException);
        this.checkSubQueries(aDQLQuery, stack, searchColumnList, unresolvedIdentifiersException);
        if (unresolvedIdentifiersException.getNbErrors() > 0) {
            throw unresolvedIdentifiersException;
        }
    }

    protected SearchColumnList checkDBItems(ADQLQuery aDQLQuery, Stack<SearchColumnList> stack, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        SearchColumnList searchColumnList;
        Map<DBTable, ADQLTable> map = this.resolveTables(aDQLQuery, stack, unresolvedIdentifiersException);
        try {
            searchColumnList = aDQLQuery.getFrom().getDBColumns();
        }
        catch (ParseException parseException) {
            unresolvedIdentifiersException.addException(parseException);
            searchColumnList = new SearchColumnList();
        }
        this.resolveColumns(aDQLQuery, stack, map, searchColumnList, unresolvedIdentifiersException);
        return searchColumnList;
    }

    protected Map<DBTable, ADQLTable> resolveTables(ADQLQuery aDQLQuery, Stack<SearchColumnList> stack, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        Object object;
        ADQLObject aDQLObject;
        HashMap<DBTable, ADQLTable> hashMap = new HashMap<DBTable, ADQLTable>();
        SimpleSearchHandler simpleSearchHandler = new SearchTableHandler();
        simpleSearchHandler.search(aDQLQuery.getFrom());
        for (ADQLObject aDQLObject2 : simpleSearchHandler) {
            try {
                aDQLObject = (ADQLTable)aDQLObject2;
                object = null;
                if (((ADQLTable)aDQLObject).isSubQuery()) {
                    this.check(((ADQLTable)aDQLObject).getSubQuery(), stack);
                    object = DBChecker.generateDBTable(((ADQLTable)aDQLObject).getSubQuery(), ((ADQLTable)aDQLObject).getAlias());
                } else {
                    object = this.resolveTable((ADQLTable)aDQLObject);
                    if (((ADQLTable)aDQLObject).hasAlias()) {
                        object = object.copy(null, ((ADQLTable)aDQLObject).getAlias());
                    }
                }
                ((ADQLTable)aDQLObject).setDBLink((DBTable)object);
                hashMap.put((DBTable)object, (ADQLTable)aDQLObject);
            }
            catch (ParseException parseException) {
                unresolvedIdentifiersException.addException(parseException);
            }
        }
        simpleSearchHandler = new SearchWildCardHandler();
        simpleSearchHandler.search(aDQLQuery.getSelect());
        for (ADQLObject aDQLObject2 : simpleSearchHandler) {
            try {
                ArrayList<ADQLTable> arrayList;
                aDQLObject = (SelectAllColumns)aDQLObject2;
                object = ((SelectAllColumns)aDQLObject).getAdqlTable();
                DBTable dBTable = null;
                if (((ADQLTable)object).getTableName() != null && ((ADQLTable)object).getSchemaName() == null && (arrayList = aDQLQuery.getFrom().getTablesByAlias(((ADQLTable)object).getTableName(), ((ADQLTable)object).isCaseSensitive(IdentifierField.TABLE))).size() == 1) {
                    dBTable = arrayList.get(0).getDBLink();
                }
                if (dBTable == null) {
                    dBTable = this.resolveTable((ADQLTable)object);
                }
                ((SelectAllColumns)aDQLObject).setAdqlTable(hashMap.get(dBTable));
            }
            catch (ParseException parseException) {
                unresolvedIdentifiersException.addException(parseException);
            }
        }
        return hashMap;
    }

    protected DBTable resolveTable(ADQLTable aDQLTable) throws ParseException {
        ArrayList<DBTable> arrayList = this.lstTables.search(aDQLTable);
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            throw new UnresolvedTableException(aDQLTable, arrayList.get(0).getADQLSchemaName() + "." + arrayList.get(0).getADQLName(), arrayList.get(1).getADQLSchemaName() + "." + arrayList.get(1).getADQLName());
        }
        throw new UnresolvedTableException(aDQLTable);
    }

    protected void resolveColumns(ADQLQuery aDQLQuery, Stack<SearchColumnList> stack, Map<DBTable, ADQLTable> map, SearchColumnList searchColumnList, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        Object object;
        SimpleSearchHandler simpleSearchHandler = new SearchColumnHandler();
        simpleSearchHandler.search(aDQLQuery);
        for (Object object2 : simpleSearchHandler) {
            try {
                ADQLObject aDQLObject = (ADQLColumn)object2;
                object = this.resolveColumn((ADQLColumn)aDQLObject, searchColumnList, stack);
                aDQLObject.setDBLink((DBColumn)object);
                aDQLObject.setAdqlTable(map.get(object.getTable()));
            }
            catch (ParseException parseException) {
                unresolvedIdentifiersException.addException(parseException);
            }
        }
        simpleSearchHandler = new SearchColReferenceHandler();
        simpleSearchHandler.search(aDQLQuery);
        ClauseSelect clauseSelect = aDQLQuery.getSelect();
        for (ADQLObject aDQLObject : simpleSearchHandler) {
            try {
                object = (ColumnReference)aDQLObject;
                DBColumn dBColumn = this.checkColumnReference((ColumnReference)object, clauseSelect, searchColumnList);
                ((ColumnReference)object).setDBLink(dBColumn);
                if (dBColumn == null) continue;
                ((ColumnReference)object).setAdqlTable(map.get(dBColumn.getTable()));
            }
            catch (ParseException parseException) {
                unresolvedIdentifiersException.addException(parseException);
            }
        }
    }

    protected DBColumn resolveColumn(ADQLColumn aDQLColumn, SearchColumnList searchColumnList, Stack<SearchColumnList> stack) throws ParseException {
        ArrayList<DBColumn> arrayList = searchColumnList.search(aDQLColumn);
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            if (aDQLColumn.getTableName() == null) {
                throw new UnresolvedColumnException(aDQLColumn, arrayList.get(0).getTable() == null ? "<NULL>" : arrayList.get(0).getTable().getADQLName() + "." + arrayList.get(0).getADQLName(), arrayList.get(1).getTable() == null ? "<NULL>" : arrayList.get(1).getTable().getADQLName() + "." + arrayList.get(1).getADQLName());
            }
            throw new UnresolvedTableException(aDQLColumn, arrayList.get(0).getTable() == null ? "<NULL>" : arrayList.get(0).getTable().getADQLName(), arrayList.get(1).getTable() == null ? "<NULL>" : arrayList.get(1).getTable().getADQLName());
        }
        if (stack == null || stack.isEmpty()) {
            throw new UnresolvedColumnException(aDQLColumn);
        }
        Stack<SearchColumnList> stack2 = new Stack<SearchColumnList>();
        stack2.addAll(stack.subList(0, stack.size() - 1));
        return this.resolveColumn(aDQLColumn, stack.peek(), stack2);
    }

    protected DBColumn checkColumnReference(ColumnReference columnReference, ClauseSelect clauseSelect, SearchColumnList searchColumnList) throws ParseException {
        if (columnReference.isIndex()) {
            int n = columnReference.getColumnIndex();
            if (n > 0 && n <= clauseSelect.size()) {
                SelectItem selectItem = (SelectItem)clauseSelect.get(n - 1);
                if (selectItem.getOperand() instanceof ADQLColumn) {
                    return ((ADQLColumn)selectItem.getOperand()).getDBLink();
                }
                return null;
            }
            throw new ParseException("Column index out of bounds: " + n + " (must be between 1 and " + clauseSelect.size() + ") !", columnReference.getPosition());
        }
        ADQLColumn aDQLColumn = new ADQLColumn(columnReference.getColumnName());
        aDQLColumn.setCaseSensitive(columnReference.isCaseSensitive());
        aDQLColumn.setPosition(columnReference.getPosition());
        if (aDQLColumn.getTableName() == null) {
            ArrayList<SelectItem> arrayList = clauseSelect.searchByAlias(columnReference.getColumnName(), columnReference.isCaseSensitive());
            if (arrayList.size() == 1) {
                return null;
            }
            if (arrayList.size() > 1) {
                throw new UnresolvedColumnException(aDQLColumn, arrayList.get(0).getAlias(), arrayList.get(1).getAlias());
            }
        }
        return this.resolveColumn(aDQLColumn, searchColumnList, null);
    }

    public static DBTable generateDBTable(ADQLQuery aDQLQuery, String string) throws ParseException {
        DBColumn[] dBColumnArray;
        DefaultDBTable defaultDBTable = new DefaultDBTable(string);
        for (DBColumn dBColumn : dBColumnArray = aDQLQuery.getResultingColumns()) {
            defaultDBTable.addColumn(dBColumn.copy(dBColumn.getADQLName(), dBColumn.getADQLName(), defaultDBTable));
        }
        return defaultDBTable;
    }

    protected void checkUDFs(ADQLQuery aDQLQuery, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        SearchUDFHandler searchUDFHandler = new SearchUDFHandler();
        searchUDFHandler.search(aDQLQuery);
        if (this.allowedUdfs.length == 0) {
            for (ADQLObject aDQLObject : searchUDFHandler) {
                unresolvedIdentifiersException.addException(new UnresolvedFunctionException((UserDefinedFunction)aDQLObject));
            }
        } else {
            int n;
            UserDefinedFunction userDefinedFunction;
            ArrayList<UserDefinedFunction> arrayList = new ArrayList<UserDefinedFunction>();
            BinarySearch<FunctionDef, UserDefinedFunction> binarySearch = new BinarySearch<FunctionDef, UserDefinedFunction>(){

                @Override
                protected int compare(UserDefinedFunction userDefinedFunction, FunctionDef functionDef) {
                    return functionDef.compareTo(userDefinedFunction) * -1;
                }
            };
            for (ADQLObject aDQLObject : searchUDFHandler) {
                userDefinedFunction = (UserDefinedFunction)aDQLObject;
                n = binarySearch.search(userDefinedFunction, this.allowedUdfs);
                if (n < 0) {
                    if (this.isAllParamTypesResolved(userDefinedFunction)) {
                        unresolvedIdentifiersException.addException(new UnresolvedFunctionException(userDefinedFunction));
                        continue;
                    }
                    arrayList.add(userDefinedFunction);
                    continue;
                }
                if (!(userDefinedFunction instanceof DefaultUDF)) continue;
                ((DefaultUDF)userDefinedFunction).setDefinition(this.allowedUdfs[n]);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                userDefinedFunction = (UserDefinedFunction)arrayList.get(i);
                n = binarySearch.search(userDefinedFunction, this.allowedUdfs);
                if (n < 0) {
                    unresolvedIdentifiersException.addException(new UnresolvedFunctionException(userDefinedFunction));
                    continue;
                }
                if (!(userDefinedFunction instanceof DefaultUDF)) continue;
                ((DefaultUDF)userDefinedFunction).setDefinition(this.allowedUdfs[n]);
            }
            new ReplaceDefaultUDFHandler(unresolvedIdentifiersException).searchAndReplace(aDQLQuery);
        }
    }

    protected final boolean isAllParamTypesResolved(ADQLFunction aDQLFunction) {
        for (ADQLOperand aDQLOperand : aDQLFunction.getParameters()) {
            if (aDQLOperand.isNumeric() != aDQLOperand.isString()) continue;
            return false;
        }
        return true;
    }

    protected void checkGeometries(ADQLQuery aDQLQuery, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        BinarySearch<String, String> binarySearch = new BinarySearch<String, String>(){

            @Override
            protected int compare(String string, String string2) {
                return string.compareToIgnoreCase(string2);
            }
        };
        if (this.allowedGeo != null) {
            this.resolveGeometryFunctions(aDQLQuery, binarySearch, unresolvedIdentifiersException);
        }
        if (this.allowedCoordSys != null) {
            this.resolveCoordinateSystems(aDQLQuery, unresolvedIdentifiersException);
        }
        if (this.allowedGeo == null || this.allowedGeo.length > 0 && binarySearch.search("REGION", this.allowedGeo) >= 0) {
            this.resolveSTCSExpressions(aDQLQuery, binarySearch, unresolvedIdentifiersException);
        }
    }

    protected void resolveGeometryFunctions(ADQLQuery aDQLQuery, BinarySearch<String, String> binarySearch, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        SearchGeometryHandler searchGeometryHandler = new SearchGeometryHandler();
        searchGeometryHandler.search(aDQLQuery);
        for (ADQLObject aDQLObject : searchGeometryHandler) {
            String string = aDQLObject.getName();
            this.checkGeometryFunction(string, (ADQLFunction)aDQLObject, binarySearch, unresolvedIdentifiersException);
        }
    }

    protected void checkGeometryFunction(String string, ADQLFunction aDQLFunction, BinarySearch<String, String> binarySearch, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        int n = -1;
        if (this.allowedGeo.length != 0) {
            n = binarySearch.search(string, (String[])this.allowedGeo);
        }
        if (n < 0) {
            unresolvedIdentifiersException.addException(new UnresolvedFunctionException("The geometrical function \"" + string + "\" is not available in this implementation!", aDQLFunction));
        }
    }

    protected void resolveCoordinateSystems(ADQLQuery aDQLQuery, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        SearchCoordSysHandler searchCoordSysHandler = new SearchCoordSysHandler();
        searchCoordSysHandler.search(aDQLQuery);
        for (ADQLObject aDQLObject : searchCoordSysHandler) {
            this.checkCoordinateSystem((StringConstant)aDQLObject, unresolvedIdentifiersException);
        }
    }

    protected void checkCoordinateSystem(StringConstant stringConstant, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        String string = stringConstant.getValue();
        try {
            this.checkCoordinateSystem(STCS.parseCoordSys(string), stringConstant, unresolvedIdentifiersException);
        }
        catch (ParseException parseException) {
            unresolvedIdentifiersException.addException(new ParseException(parseException.getMessage()));
        }
    }

    protected void checkCoordinateSystem(STCS.CoordSys coordSys, ADQLOperand aDQLOperand, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        if (this.coordSysRegExp != null && coordSys != null && !coordSys.toFullSTCS().matches(this.coordSysRegExp)) {
            unresolvedIdentifiersException.addException(new ParseException("Coordinate system \"" + (aDQLOperand instanceof StringConstant ? ((StringConstant)aDQLOperand).getValue() : coordSys.toString()) + "\" (= \"" + coordSys.toFullSTCS() + "\") not allowed in this implementation."));
        }
    }

    protected void resolveSTCSExpressions(ADQLQuery aDQLQuery, BinarySearch<String, String> binarySearch, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        SearchRegionHandler searchRegionHandler = new SearchRegionHandler();
        searchRegionHandler.search(aDQLQuery);
        for (ADQLObject aDQLObject : searchRegionHandler) {
            try {
                String string = ((StringConstant)((RegionFunction)aDQLObject).getParameter(0)).getValue();
                STCS.Region region = STCS.parseRegion(string);
                this.checkRegion(region, (RegionFunction)aDQLObject, binarySearch, unresolvedIdentifiersException);
            }
            catch (ParseException parseException) {
                unresolvedIdentifiersException.addException(new ParseException(parseException.getMessage()));
            }
        }
    }

    protected void checkRegion(STCS.Region region, RegionFunction regionFunction, BinarySearch<String, String> binarySearch, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        if (region == null) {
            return;
        }
        if (region.coordSys != null) {
            this.checkCoordinateSystem(region.coordSys, regionFunction, unresolvedIdentifiersException);
        }
        if (this.allowedGeo != null) {
            if (this.allowedGeo.length == 0) {
                unresolvedIdentifiersException.addException(new UnresolvedFunctionException("The region type \"" + (Object)((Object)region.type) + "\" is not available in this implementation!", regionFunction));
            } else {
                this.checkGeometryFunction(region.type == STCS.RegionType.POSITION ? "POINT" : region.type.toString(), regionFunction, binarySearch, unresolvedIdentifiersException);
            }
        }
        if (region.regions != null) {
            for (STCS.Region region2 : region.regions) {
                this.checkRegion(region2, regionFunction, binarySearch, unresolvedIdentifiersException);
            }
        }
    }

    protected void checkTypes(ADQLQuery aDQLQuery, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        SearchUnknownTypeHandler searchUnknownTypeHandler = new SearchUnknownTypeHandler();
        searchUnknownTypeHandler.search(aDQLQuery);
        for (ADQLObject aDQLObject : searchUnknownTypeHandler) {
            UnknownType unknownType = (UnknownType)aDQLObject;
            switch (unknownType.getExpectedType()) {
                case 'G': 
                case 'g': {
                    if (unknownType.isGeometry()) break;
                    unresolvedIdentifiersException.addException(new ParseException("Type mismatch! A geometry was expected instead of \"" + unknownType.toADQL() + "\"."));
                    break;
                }
                case 'N': 
                case 'n': {
                    if (unknownType.isNumeric()) break;
                    unresolvedIdentifiersException.addException(new ParseException("Type mismatch! A numeric value was expected instead of \"" + unknownType.toADQL() + "\"."));
                    break;
                }
                case 'S': 
                case 's': {
                    if (unknownType.isString()) break;
                    unresolvedIdentifiersException.addException(new ParseException("Type mismatch! A string value was expected instead of \"" + unknownType.toADQL() + "\"."));
                }
            }
        }
    }

    protected void checkSubQueries(ADQLQuery aDQLQuery, Stack<SearchColumnList> stack, SearchColumnList searchColumnList, UnresolvedIdentifiersException unresolvedIdentifiersException) {
        SearchSubQueryHandler searchSubQueryHandler = new SearchSubQueryHandler();
        searchSubQueryHandler.search(aDQLQuery);
        if (searchSubQueryHandler.getNbMatch() > 0) {
            if (stack == null) {
                stack = new Stack();
            }
            stack.push(searchColumnList);
            for (ADQLObject aDQLObject : searchSubQueryHandler) {
                try {
                    this.check((ADQLQuery)aDQLObject, stack);
                }
                catch (UnresolvedIdentifiersException unresolvedIdentifiersException2) {
                    Iterator<ParseException> iterator = unresolvedIdentifiersException2.getErrors();
                    while (iterator.hasNext()) {
                        unresolvedIdentifiersException.addException(iterator.next());
                    }
                }
            }
            stack.pop();
        }
    }

    protected static abstract class BinarySearch<T, S> {
        private int s;
        private int e;
        private int m;
        private int comp;

        protected BinarySearch() {
        }

        public int search(S s, T[] TArray) {
            this.s = 0;
            this.e = TArray.length - 1;
            while (this.s < this.e) {
                this.m = this.s + (this.e - this.s) / 2;
                this.comp = this.compare(s, TArray[this.m]);
                if (this.comp > 0) {
                    this.s = this.m + 1;
                    continue;
                }
                this.e = this.m;
            }
            if (this.s != this.e || this.compare(s, TArray[this.s]) != 0) {
                return -1;
            }
            return this.s;
        }

        protected abstract int compare(S var1, T var2);
    }

    private static class SearchRegionHandler
    extends SimpleSearchHandler {
        private SearchRegionHandler() {
        }

        @Override
        protected boolean match(ADQLObject aDQLObject) {
            if (aDQLObject instanceof RegionFunction) {
                return ((RegionFunction)aDQLObject).getParameter(0) instanceof StringConstant;
            }
            return false;
        }
    }

    private static class SearchCoordSysHandler
    extends SimpleSearchHandler {
        private SearchCoordSysHandler() {
        }

        @Override
        protected boolean match(ADQLObject aDQLObject) {
            if (aDQLObject instanceof PointFunction || aDQLObject instanceof BoxFunction || aDQLObject instanceof CircleFunction || aDQLObject instanceof PolygonFunction) {
                return ((GeometryFunction)aDQLObject).getCoordinateSystem() instanceof StringConstant;
            }
            return false;
        }

        @Override
        protected void addMatch(ADQLObject aDQLObject, ADQLIterator aDQLIterator) {
            this.results.add(((GeometryFunction)aDQLObject).getCoordinateSystem());
        }
    }

    private static class SearchUnknownTypeHandler
    extends SimpleSearchHandler {
        private SearchUnknownTypeHandler() {
        }

        @Override
        protected boolean match(ADQLObject aDQLObject) {
            if (aDQLObject instanceof UnknownType) {
                char c = ((UnknownType)aDQLObject).getExpectedType();
                return c == 'G' || c == 'g' || c == 'S' || c == 's' || c == 'N' || c == 'n';
            }
            return false;
        }
    }

    private static class SearchGeometryHandler
    extends SimpleSearchHandler {
        private SearchGeometryHandler() {
        }

        @Override
        protected boolean match(ADQLObject aDQLObject) {
            return aDQLObject instanceof GeometryFunction;
        }
    }

    private static class ReplaceDefaultUDFHandler
    extends SimpleReplaceHandler {
        private final UnresolvedIdentifiersException errors;

        public ReplaceDefaultUDFHandler(UnresolvedIdentifiersException unresolvedIdentifiersException) {
            this.errors = unresolvedIdentifiersException;
        }

        @Override
        protected boolean match(ADQLObject aDQLObject) {
            return aDQLObject.getClass().getName().equals(DefaultUDF.class.getName()) && ((DefaultUDF)aDQLObject).getDefinition() != null && ((DefaultUDF)aDQLObject).getDefinition().getUDFClass() != null;
        }

        @Override
        protected ADQLObject getReplacer(ADQLObject aDQLObject) throws UnsupportedOperationException {
            try {
                Class<? extends UserDefinedFunction> clazz = ((DefaultUDF)aDQLObject).getDefinition().getUDFClass();
                Constructor<? extends UserDefinedFunction> constructor = clazz.getConstructor(ADQLOperand[].class);
                return constructor.newInstance(new Object[]{((DefaultUDF)aDQLObject).getParameters()});
            }
            catch (Exception exception) {
                this.errors.addException(new UnresolvedFunctionException("Impossible to represent the function \"" + ((DefaultUDF)aDQLObject).getName() + "\": the following error occured while creating this representation: \"" + (exception instanceof InvocationTargetException ? "[" + exception.getCause().getClass().getSimpleName() + "] " + exception.getCause().getMessage() : exception.getMessage()) + "\"", (DefaultUDF)aDQLObject));
                return aDQLObject;
            }
        }
    }

    private static class SearchUDFHandler
    extends SimpleSearchHandler {
        private SearchUDFHandler() {
        }

        @Override
        protected boolean match(ADQLObject aDQLObject) {
            return aDQLObject instanceof UserDefinedFunction;
        }
    }

    private static class SearchSubQueryHandler
    extends SimpleSearchHandler {
        private SearchSubQueryHandler() {
        }

        @Override
        protected void addMatch(ADQLObject aDQLObject, ADQLIterator aDQLIterator) {
            if (aDQLIterator != null) {
                super.addMatch(aDQLObject, aDQLIterator);
            }
        }

        @Override
        protected boolean goInto(ADQLObject aDQLObject) {
            return super.goInto(aDQLObject) && !(aDQLObject instanceof FromContent);
        }

        @Override
        protected boolean match(ADQLObject aDQLObject) {
            return aDQLObject instanceof ADQLQuery;
        }
    }

    private static class SearchColReferenceHandler
    extends SimpleSearchHandler {
        private SearchColReferenceHandler() {
        }

        @Override
        public boolean match(ADQLObject aDQLObject) {
            return aDQLObject instanceof ColumnReference;
        }
    }

    private static class SearchWildCardHandler
    extends SimpleSearchHandler {
        private SearchWildCardHandler() {
        }

        @Override
        public boolean match(ADQLObject aDQLObject) {
            return aDQLObject instanceof SelectAllColumns && ((SelectAllColumns)aDQLObject).getAdqlTable() != null;
        }
    }

    private static class SearchTableHandler
    extends SimpleSearchHandler {
        private SearchTableHandler() {
        }

        @Override
        public boolean match(ADQLObject aDQLObject) {
            return aDQLObject instanceof ADQLTable;
        }
    }
}

